package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldControlledTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.constants.*;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.permanent.TokenPredicate;

/**
 *
 * @author NinthWorld
 */
public final class GeneralHux extends CardImpl {

    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("{this} or another nontoken creature you control");

    static {
        filter.add(TargetController.YOU.getControllerPredicate());
        filter.add(TokenPredicate.FALSE);
    }

    public GeneralHux(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{B}");
        
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.ADVISOR);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);

        // Whenever General Hux or another nontoken creature you control enters, until end of turn, target creature gains "{B}: This creature gets +1/+1 until end of turn."
        Ability ability = new SimpleActivatedAbility(
                new BoostSourceEffect(1, 1, Duration.EndOfTurn)
                        .setText("This creature gets +1/+1 until end of turn"),
                new ManaCostsImpl<>("{B}"));
        Effect effect = new GainAbilitySourceEffect(ability, Duration.EndOfTurn);
        effect.setText("until end of turn, target creature gains");
        this.addAbility(new EntersBattlefieldControlledTriggeredAbility(Zone.BATTLEFIELD, effect, filter, false));
    }

    private GeneralHux(final GeneralHux card) {
        super(card);
    }

    @Override
    public GeneralHux copy() {
        return new GeneralHux(this);
    }
}
