
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityPairedEffect;
import mage.abilities.keyword.SoulbondAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 * @author noxx
 */
public final class GalvanicAlchemist extends CardImpl {

    private static final String ruleText = "As long as {this} is paired with another creature, each of those creatures has \"{2}{U}: Untap this creature.\"";

    public GalvanicAlchemist(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{U}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WIZARD);

        this.power = new MageInt(1);
        this.toughness = new MageInt(4);

        // Soulbond
        this.addAbility(new SoulbondAbility());

        // As long as Galvanic Alchemist is paired with another creature, each of those creatures has "{2}{U}: Untap this creature."
        Ability ability = new SimpleActivatedAbility(new UntapSourceEffect(), new ManaCostsImpl<>("{2}{U}"));
        this.addAbility(new SimpleStaticAbility(new GainAbilityPairedEffect(ability, ruleText)));
    }

    private GalvanicAlchemist(final GalvanicAlchemist card) {
        super(card);
    }

    @Override
    public GalvanicAlchemist copy() {
        return new GalvanicAlchemist(this);
    }
}
