
package mage.cards.f;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DontUntapInControllersUntapStepAllEffect;
import mage.abilities.keyword.CumulativeUpkeepAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;

/**
 *
 * @author TheElk801
 */
public final class FreyalisesRadiance extends CardImpl {

    private static final FilterPermanent filter = new FilterPermanent("snow permanents");

    static {
        filter.add(SuperType.SNOW.getPredicate());
    }

    public FreyalisesRadiance(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{G}");

        // Cumulative upkeep {2}
        this.addAbility(new CumulativeUpkeepAbility(new ManaCostsImpl<>("{2}")));

        // Snow permanents don't untap during their controllers' untap steps.
        this.addAbility(new SimpleStaticAbility(new DontUntapInControllersUntapStepAllEffect(Duration.WhileOnBattlefield, TargetController.ANY, filter)));
    }

    private FreyalisesRadiance(final FreyalisesRadiance card) {
        super(card);
    }

    @Override
    public FreyalisesRadiance copy() {
        return new FreyalisesRadiance(this);
    }
}
