
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author North
 */
public final class FoxfireOak extends CardImpl {

    public FoxfireOak(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{5}{G}");
        this.subtype.add(SubType.TREEFOLK);
        this.subtype.add(SubType.SHAMAN);

        this.power = new MageInt(3);
        this.toughness = new MageInt(6);

        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(3, 0, Duration.EndOfTurn), new ManaCostsImpl<>("{R/G}{R/G}{R/G}")));
    }

    private FoxfireOak(final FoxfireOak card) {
        super(card);
    }

    @Override
    public FoxfireOak copy() {
        return new FoxfireOak(this);
    }
}
