
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledLandPermanent;
import mage.target.common.TargetControlledPermanent;

/**
 *
 * @author Plopman
 */
public final class Foratog extends CardImpl {

    private static final FilterControlledLandPermanent filter = new FilterControlledLandPermanent("a Forest");
    static{
        filter.add(SubType.FOREST.getPredicate());
    }
    public Foratog(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{G}");
        this.subtype.add(SubType.ATOG);

        this.power = new MageInt(1);
        this.toughness = new MageInt(2);

        // {G}, Sacrifice a Forest: Foratog gets +2/+2 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostSourceEffect(2, 2, Duration.EndOfTurn), new ManaCostsImpl<>("{G}"));
        ability.addCost(new SacrificeTargetCost(filter));
        this.addAbility(ability);
    }

    private Foratog(final Foratog card) {
        super(card);
    }

    @Override
    public Foratog copy() {
        return new Foratog(this);
    }
}
