
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.target.common.TargetPlayerOrPlaneswalker;

/**
 *
 * @author LevelX2
 */
public final class FontOfIre extends CardImpl {

    public FontOfIre(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");

        // {3}{R}, Sacrifice Font of Ire: Font of Ire deals 5 damage to target player.
        Ability ability = new SimpleActivatedAbility(new DamageTargetEffect(5, "it"), new ManaCostsImpl<>("{3}{R}"));
        ability.addCost(new SacrificeSourceCost());
        ability.addTarget(new TargetPlayerOrPlaneswalker());
        this.addAbility(ability);
    }

    private FontOfIre(final FontOfIre card) {
        super(card);
    }

    @Override
    public FontOfIre copy() {
        return new FontOfIre(this);
    }
}
