
package mage.cards.f;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.StaticFilters;

/**
 *
 * @author TheElk801
 */
public final class FlowstoneSurge extends CardImpl {

    public FlowstoneSurge(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");

        // Creatures you control get +1/-1.
        this.addAbility(new SimpleStaticAbility(new BoostControlledEffect(1, -1, Duration.WhileOnBattlefield, StaticFilters.FILTER_PERMANENT_CREATURES, false)));
    }

    private FlowstoneSurge(final FlowstoneSurge card) {
        super(card);
    }

    @Override
    public FlowstoneSurge copy() {
        return new FlowstoneSurge(this);
    }
}
