
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LoneFox

 */
public final class FlowstoneOverseer extends CardImpl {

    public FlowstoneOverseer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{R}{R}{R}");
        this.subtype.add(SubType.BEAST);
        this.power = new MageInt(4);
        this.toughness = new MageInt(4);

        // {R}{R}: Target creature gets +1/-1 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostTargetEffect(1, -1, Duration.EndOfTurn), new ManaCostsImpl<>("{R}{R}"));
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private FlowstoneOverseer(final FlowstoneOverseer card) {
        super(card);
    }

    @Override
    public FlowstoneOverseer copy() {
        return new FlowstoneOverseer(this);
    }
}
