
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class FlailingSoldier extends CardImpl {

    public FlailingSoldier(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{R}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // {1}: Flailing Soldier gets +1/+1 until end of turn. Any player may activate this ability.
        SimpleActivatedAbility ability = new SimpleActivatedAbility(new BoostSourceEffect(1, 1, Duration.EndOfTurn) , new ManaCostsImpl<>("{1}"));
        ability.setMayActivate(TargetController.ANY);
        ability.addEffect(new InfoEffect("Any player may activate this ability"));
        this.addAbility(ability);
        // {1}: Flailing Soldier gets -1/-1 until end of turn. Any player may activate this ability.
        ability = new SimpleActivatedAbility(new BoostSourceEffect(-1, -1, Duration.EndOfTurn) , new ManaCostsImpl<>("{1}"));
        ability.setMayActivate(TargetController.ANY);
        ability.addEffect(new InfoEffect("Any player may activate this ability"));
        this.addAbility(ability);
    }

    private FlailingSoldier(final FlailingSoldier card) {
        super(card);
    }

    @Override
    public FlailingSoldier copy() {
        return new FlailingSoldier(this);
    }
}
