
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;

/**
 *
 * @author fireshoes
 */
public final class FeralThallid extends CardImpl {

    public FeralThallid(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{G}{G}{G}");
        this.subtype.add(SubType.FUNGUS);
        this.power = new MageInt(6);
        this.toughness = new MageInt(3);

        // At the beginning of your upkeep, put a spore counter on Feral Thallid.
        this.addAbility(new BeginningOfUpkeepTriggeredAbility(new AddCountersSourceEffect(CounterType.SPORE.createInstance())));
        // Remove three spore counters from Feral Thallid: Regenerate Feral Thallid.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new RemoveCountersSourceCost(CounterType.SPORE.createInstance(3))));
    }

    private FeralThallid(final FeralThallid card) {
        super(card);
    }

    @Override
    public FeralThallid copy() {
        return new FeralThallid(this);
    }
}
