
package mage.cards.f;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.MayTapOrUntapTargetEffect;
import mage.abilities.keyword.UnearthAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.target.TargetPermanent;

/**
 *
 * @author Plopman
 */
public final class Fatestitcher extends CardImpl {
    
    private static final FilterPermanent filter = new FilterPermanent("another target permanent");
    static{
        filter.add(AnotherPredicate.instance);
    }

    public Fatestitcher(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{U}");
        this.subtype.add(SubType.ZOMBIE);
        this.subtype.add(SubType.WIZARD);

        this.power = new MageInt(1);
        this.toughness = new MageInt(2);

        // {tap}: You may tap or untap another target permanent.
        Ability ability = new SimpleActivatedAbility(new MayTapOrUntapTargetEffect(), new TapSourceCost());
        ability.addTarget(new TargetPermanent(filter));
        this.addAbility(ability);
        // Unearth {U}
        this.addAbility(new UnearthAbility(new ManaCostsImpl<>("{U}")));
    }

    private Fatestitcher(final Fatestitcher card) {
        super(card);
    }

    @Override
    public Fatestitcher copy() {
        return new Fatestitcher(this);
    }
}
