package mage.cards.f;



import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.common.TargetAnyTarget;

import java.util.UUID;


/**
 *
 * @author JayDi85
 */
public final class FanaticalFirebrand extends CardImpl {

    public FanaticalFirebrand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{R}");

        this.subtype.add(SubType.GOBLIN);
        this.subtype.add(SubType.PIRATE);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Haste
        this.addAbility(HasteAbility.getInstance());

        // {T}, Sacrifice Fanatical Firebrand: It deals 1 damage to any target.
        Ability ability = new SimpleActivatedAbility(new DamageTargetEffect(1, "It"), new TapSourceCost());
        ability.addCost(new SacrificeSourceCost());
        ability.addTarget(new TargetAnyTarget());
        this.addAbility(ability);
    }

    private FanaticalFirebrand(final FanaticalFirebrand card) {
        super(card);
    }

    @Override
    public FanaticalFirebrand copy() {
        return new FanaticalFirebrand(this);
    }
}
