
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.target.common.TargetAnyTarget;

/**
 *
 * @author fireshoes
 */
public final class ExplosiveApparatus extends CardImpl {

    public ExplosiveApparatus(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{1}");

        // {3}, {T}, Sacrifice Explosive Apparatus: Explosive Apparatus deals 2 damage to any target.
        Ability ability = new SimpleActivatedAbility(new DamageTargetEffect(2, "It"), new GenericManaCost(3));
        ability.addCost(new TapSourceCost());
        ability.addCost(new SacrificeSourceCost());
        ability.addTarget(new TargetAnyTarget());
        this.addAbility(ability);
    }

    private ExplosiveApparatus(final ExplosiveApparatus card) {
        super(card);
    }

    @Override
    public ExplosiveApparatus copy() {
        return new ExplosiveApparatus(this);
    }
}
