
package mage.cards.e;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.keyword.CantBeBlockedSourceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.common.TargetCardInHand;

/**
 *
 * @author cbt33
 */
public final class EscapeArtist extends CardImpl {

    public EscapeArtist(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{U}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WIZARD);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Escape Artist can't be blocked.
        this.addAbility(new CantBeBlockedSourceAbility());
        // {U}, Discard a card: Return Escape Artist to its owner's hand.
        Ability ability = new SimpleActivatedAbility(new ReturnToHandSourceEffect(true), new ManaCostsImpl<>("{U}"));
        ability.addCost(new DiscardTargetCost(new TargetCardInHand()));
        this.addAbility(ability);
    }

    private EscapeArtist(final EscapeArtist card) {
        super(card);
    }

    @Override
    public EscapeArtist copy() {
        return new EscapeArtist(this);
    }
}
