
package mage.cards.e;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MonarchIsSourceControllerCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.BecomesMonarchSourceEffect;
import mage.abilities.effects.common.combat.CanBlockAdditionalCreatureEffect;
import mage.abilities.hint.common.MonarchHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class EntourageOfTrest extends CardImpl {

    public EntourageOfTrest(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{4}{G}");

        this.subtype.add(SubType.ELF);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(4);
        this.toughness = new MageInt(4);

        // When Entourage of Trest enters the battlefield, you become the monarch.
        this.addAbility(new EntersBattlefieldTriggeredAbility(new BecomesMonarchSourceEffect()).addHint(MonarchHint.instance));

        // Entourage of Trest can block an additional creature each combat as long as you're the monarch.
        this.addAbility(new SimpleStaticAbility(new ConditionalContinuousEffect(
                new CanBlockAdditionalCreatureEffect(1), MonarchIsSourceControllerCondition.instance,
                "{this} can block an additional creature each combat as long as you're the monarch")));
    }

    private EntourageOfTrest(final EntourageOfTrest card) {
        super(card);
    }

    @Override
    public EntourageOfTrest copy() {
        return new EntourageOfTrest(this);
    }
}
