
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.combat.CanBlockAdditionalCreatureEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Rene bugisemail at gmail dot com
 */
public final class Entangler extends CardImpl {

    public Entangler(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{W}");
        
        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.BoostCreature));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // Enchanted creature can block any number of creatures.
        SimpleStaticAbility blockAbility = new SimpleStaticAbility(new CanBlockAdditionalCreatureEffect(0));
        Effect effect = new GainAbilityAttachedEffect(blockAbility,AttachmentType.AURA, Duration.WhileOnBattlefield);
        effect.setText("Enchanted creature can block any number of creatures.");
        this.addAbility(new SimpleStaticAbility(effect));
    }

    private Entangler(final Entangler card) {
        super(card);
    }

    @Override
    public Entangler copy() {
        return new Entangler(this);
    }
}
