
package mage.cards.e;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.MountainwalkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class EnslavedScout extends CardImpl {

    public EnslavedScout(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{R}");
        this.subtype.add(SubType.GOBLIN);
        this.subtype.add(SubType.SCOUT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // {2}: Enslaved Scout gains mountainwalk until end of turn.
        this.addAbility(new SimpleActivatedAbility(
                new GainAbilitySourceEffect(new MountainwalkAbility(false), Duration.EndOfTurn),
                new GenericManaCost(2)));
    }

    private EnslavedScout(final EnslavedScout card) {
        super(card);
    }

    @Override
    public EnslavedScout copy() {
        return new EnslavedScout(this);
    }
}
