
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SkipUntapOptionalAbility;
import mage.abilities.condition.common.SourceTappedCondition;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author LoneFox
 */
public final class Endoskeleton extends CardImpl {

    public Endoskeleton(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{2}");

        // You may choose not to untap Endoskeleton during your untap step.
        this.addAbility(new SkipUntapOptionalAbility());
        // {2}, {tap}: Target creature gets +0/+3 for as long as Endoskeleton remains tapped.
        Ability ability = new SimpleActivatedAbility(new ConditionalContinuousEffect(
            new BoostTargetEffect(0, 3, Duration.Custom), SourceTappedCondition.TAPPED,
            "target creature gets +0/+3 for as long as {this} remains tapped"), new ManaCostsImpl<>("{2}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private Endoskeleton(final Endoskeleton card) {
        super(card);
    }

    @Override
    public Endoskeleton copy() {
        return new Endoskeleton(this);
    }
}
