package mage.cards.e;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.SubType;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.target.common.TargetCardInLibrary;

/**
 *
 * @author TheElk801
 */
public final class ElvishClancaller extends CardImpl {

    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Elves");
    private static final FilterCard filter2 = new FilterCard("card named Elvish Clancaller");

    static {
        filter.add(SubType.ELF.getPredicate());
        filter2.add(new NamePredicate("Elvish Clancaller"));
    }

    public ElvishClancaller(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{G}{G}");

        this.subtype.add(SubType.ELF);
        this.subtype.add(SubType.DRUID);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Other Elves you control get +1/+1.
        this.addAbility(new SimpleStaticAbility(
                new BoostControlledEffect(
                        1, 1, Duration.WhileOnBattlefield,
                        filter, true
                )
        ));

        // {4}{G}{G}, {T}: Search your library for a card named Elvish Clancaller, put it onto the battlefield, then shuffle your library.
        Ability ability = new SimpleActivatedAbility(
                new SearchLibraryPutInPlayEffect(
                        new TargetCardInLibrary(filter2),
                        false
                ),
                new ManaCostsImpl<>("{4}{G}{G}"));
        ability.addCost(new TapSourceCost());
        this.addAbility(ability);
    }

    private ElvishClancaller(final ElvishClancaller card) {
        super(card);
    }

    @Override
    public ElvishClancaller copy() {
        return new ElvishClancaller(this);
    }
}
