
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.RegenerateTargetEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.target.TargetPermanent;

/**
 *
 * @author anonymous
 */
public final class ElephantGraveyard extends CardImpl {
    
    private static final FilterPermanent filter = new FilterPermanent(SubType.ELEPHANT, "Elephant");

    public ElephantGraveyard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.LAND},"");

        // {tap}: Add {C}.
        this.addAbility(new ColorlessManaAbility());
        // {tap}: Regenerate target Elephant.
        Ability ability = new SimpleActivatedAbility(new RegenerateTargetEffect(), new TapSourceCost());
        ability.addTarget(new TargetPermanent(filter));
        this.addAbility(ability);
    }

    private ElephantGraveyard(final ElephantGraveyard card) {
        super(card);
    }

    @Override
    public ElephantGraveyard copy() {
        return new ElephantGraveyard(this);
    }
}
