
package mage.cards.e;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.abilities.effects.common.discard.DiscardEachPlayerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class EarsplittingRats extends CardImpl {

    public EarsplittingRats(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{B}");
        this.subtype.add(SubType.RAT);

        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // When Earsplitting Rats enters the battlefield, each player discards a card.
        this.addAbility(new EntersBattlefieldTriggeredAbility(new DiscardEachPlayerEffect()));
        // Discard a card: Regenerate Earsplitting Rats.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new DiscardCardCost()));
    }

    private EarsplittingRats(final EarsplittingRats card) {
        super(card);
    }

    @Override
    public EarsplittingRats copy() {
        return new EarsplittingRats(this);
    }
}
