package mage.cards.d;

import mage.abilities.Mode;
import mage.abilities.condition.common.ControlACommanderCondition;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.MultipliedValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.target.TargetPlayer;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class DrownInDreams extends CardImpl {

    private static final DynamicValue xValue = new MultipliedValue(GetXValue.instance, 2);

    public DrownInDreams(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{X}{2}{U}");

        // Choose one. If you control a commander as you cast this spell, you may choose both.
        this.getSpellAbility().getModes().setChooseText(
                "Choose one. If you control a commander as you cast this spell, you may choose both instead."
        );
        this.getSpellAbility().getModes().setMoreCondition(2, ControlACommanderCondition.instance);

        // • Target player draws X cards.
        this.getSpellAbility().addEffect(new DrawCardTargetEffect(GetXValue.instance));
        this.getSpellAbility().addTarget(new TargetPlayer().withChooseHint("draws X cards"));

        // • Target player mills twice X cards.
        Mode mode = new Mode(new MillCardsTargetEffect(xValue).setText("target player mills twice X cards"));
        mode.addTarget(new TargetPlayer().withChooseHint("mills twice X cards"));
        this.getSpellAbility().addMode(mode);
    }

    private DrownInDreams(final DrownInDreams card) {
        super(card);
    }

    @Override
    public DrownInDreams copy() {
        return new DrownInDreams(this);
    }
}
