package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.mana.AnyColorManaAbility;
import mage.constants.SubType;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.game.permanent.token.DragonToken2;

/**
 *
 * @author TheElk801
 */
public final class DraconicDisciple extends CardImpl {

    public DraconicDisciple(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{R}{G}");

        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.SHAMAN);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // {T}: Add one mana of any color.
        this.addAbility(new AnyColorManaAbility());

        // {7}, {T}, Sacrifice Draconic Disciple: Create a 5/5 red Dragon creature token with flying.
        Ability ability = new SimpleActivatedAbility(
                new CreateTokenEffect(new DragonToken2()),
                new GenericManaCost(7)
        );
        ability.addCost(new TapSourceCost());
        ability.addCost(new SacrificeSourceCost());
        this.addAbility(ability);
    }

    private DraconicDisciple(final DraconicDisciple card) {
        super(card);
    }

    @Override
    public DraconicDisciple copy() {
        return new DraconicDisciple(this);
    }
}
