
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.abilities.keyword.FearAbility;
import mage.abilities.keyword.TransmuteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 *
 * @author Loki
 */
public final class DimirHouseGuard extends CardImpl {

    public DimirHouseGuard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{B}");
        this.subtype.add(SubType.SKELETON);

        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        this.addAbility(FearAbility.getInstance());
        // Sacrifice a creature: Regenerate Dimir House Guard.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(),
                new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT_CREATURE)));
        // Transmute {1}{B}{B}
        this.addAbility(new TransmuteAbility("{1}{B}{B}"));
    }

    private DimirHouseGuard(final DimirHouseGuard card) {
        super(card);
    }

    @Override
    public DimirHouseGuard copy() {
        return new DimirHouseGuard(this);
    }
}
