
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author nigelzor
 */
public final class DiabolicMachine extends CardImpl {

    public DiabolicMachine(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT,CardType.CREATURE},"{7}");
        this.subtype.add(SubType.CONSTRUCT);
        this.power = new MageInt(4);
        this.toughness = new MageInt(4);

        // {3}: Regenerate Diabolic Machine.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new GenericManaCost(3)));
    }

    private DiabolicMachine(final DiabolicMachine card) {
        super(card);
    }

    @Override
    public DiabolicMachine copy() {
        return new DiabolicMachine(this);
    }
}
