package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledPermanent;
import mage.target.common.TargetControlledPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Loki
 */
public final class DerangedOutcast extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a Human");

    static {
        filter.add(SubType.HUMAN.getPredicate());
    }

    public DerangedOutcast(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{G}");
        this.subtype.add(SubType.HUMAN, SubType.ROGUE);

        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // {1}{G}, Sacrifice a Human: Put two +1/+1 counters on target creature.
        Ability ability = new SimpleActivatedAbility(new AddCountersTargetEffect(CounterType.P1P1.createInstance(2)), new ManaCostsImpl<>("{1}{G}"));
        ability.addCost(new SacrificeTargetCost(filter));
        ability.addTarget(new TargetCreaturePermanent().withChooseHint("two +1/+1 counters"));
        this.addAbility(ability);
    }

    private DerangedOutcast(final DerangedOutcast card) {
        super(card);
    }

    @Override
    public DerangedOutcast copy() {
        return new DerangedOutcast(this);
    }
}
