
package mage.cards.d;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 *
 * @author nantuko
 */
public final class DemonmailHauberk extends CardImpl {

    public DemonmailHauberk(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{4}");
        this.subtype.add(SubType.EQUIPMENT);

        // Equipped creature gets +4/+2.
        this.addAbility(new SimpleStaticAbility(new BoostEquippedEffect(4, 2)));

        // Equip - Sacrifice a creature.
        this.addAbility(new EquipAbility(
                Outcome.AddAbility,
                new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT_CREATURE),
                false));
    }

    private DemonmailHauberk(final DemonmailHauberk card) {
        super(card);
    }

    @Override
    public DemonmailHauberk copy() {
        return new DemonmailHauberk(this);
    }
}
