
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.RegenerateSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author Plopman
 */
public final class DeepwoodGhoul extends CardImpl {

    public DeepwoodGhoul(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{B}");
        this.subtype.add(SubType.ZOMBIE);

        this.power = new MageInt(2);
        this.toughness = new MageInt(1);

        // Pay 2 life: Regenerate Deepwood Ghoul.
        this.addAbility(new SimpleActivatedAbility(new RegenerateSourceEffect(), new PayLifeCost(2)));
   }

    private DeepwoodGhoul(final DeepwoodGhoul card) {
        super(card);
    }

    @Override
    public DeepwoodGhoul copy() {
        return new DeepwoodGhoul(this);
    }
}
