
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.combat.CantBeBlockedAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.mageobject.ColorPredicate;

/**
 *
 * @author North
 */
public final class DeepchannelMentor extends CardImpl {

    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("Blue creatures you control");

    static {
        filter.add(new ColorPredicate(ObjectColor.BLUE));
    }

    public DeepchannelMentor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{5}{U}");
        this.subtype.add(SubType.MERFOLK);
        this.subtype.add(SubType.ROGUE);

        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // Blue creatures you control can't be blocked.
        this.addAbility(new SimpleStaticAbility(new CantBeBlockedAllEffect(filter, Duration.WhileOnBattlefield)));
    }

    private DeepchannelMentor(final DeepchannelMentor card) {
        super(card);
    }

    @Override
    public DeepchannelMentor copy() {
        return new DeepchannelMentor(this);
    }
}
