
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.PreventDamageToControllerEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class DecoratedGriffin extends CardImpl {

    public DecoratedGriffin(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{4}{W}");
        this.subtype.add(SubType.GRIFFIN);

        this.power = new MageInt(2);
        this.toughness = new MageInt(3);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // {1}{W}: Prevent the next 1 combat damage that would be dealt to you this turn.
        this.addAbility(new SimpleActivatedAbility(new PreventDamageToControllerEffect(Duration.EndOfTurn, true, true, 1), new ManaCostsImpl<>("{1}{W}")));
    }

    private DecoratedGriffin(final DecoratedGriffin card) {
        super(card);
    }

    @Override
    public DecoratedGriffin copy() {
        return new DecoratedGriffin(this);
    }
}
