
package mage.cards.d;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventAllDamageToSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author spjspj
 */
public final class DawnElemental extends CardImpl {

    public DawnElemental(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{W}{W}{W}{W}");

        this.subtype.add(SubType.ELEMENTAL);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);

        // Flying
        this.addAbility(FlyingAbility.getInstance());

        // Prevent all damage that would be dealt to Dawn Elemental.
        Effect effect = new PreventAllDamageToSourceEffect(Duration.WhileOnBattlefield);
        effect.setText("Prevent all damage that would be dealt to {this}");
        this.addAbility(new SimpleStaticAbility(effect));
    }

    private DawnElemental(final DawnElemental card) {
        super(card);
    }

    @Override
    public DawnElemental copy() {
        return new DawnElemental(this);
    }
}
