
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.keyword.ScryEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;

/**
 *
 * @author LevelX2
 */
public final class DarksteelPendant extends CardImpl {

    public DarksteelPendant(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{2}");

        // Darksteel Pendant is indestructible.
        this.addAbility(IndestructibleAbility.getInstance());
        // {1}, {tap}: Scry 1.
        Ability ability = new SimpleActivatedAbility(new ScryEffect(1), new GenericManaCost(1));
        ability.addCost(new TapSourceCost());
        this.addAbility(ability);
    }

    private DarksteelPendant(final DarksteelPendant card) {
        super(card);
    }

    @Override
    public DarksteelPendant copy() {
        return new DarksteelPendant(this);
    }
}
