
package mage.cards.d;

import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.target.common.TargetControlledCreaturePermanent;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class DarkTriumph extends CardImpl {

    private static final Condition condition = new PermanentsOnTheBattlefieldCondition(
            new FilterPermanent(SubType.SWAMP, "If you control a Swamp")
    );

    public DarkTriumph(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{4}{B}");

        // If you control a Swamp, you may sacrifice a creature rather than pay Dark Triumph's mana cost.
        this.addAbility(new AlternativeCostSourceAbility(
                new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT_CREATURE), condition
        ));

        // Creatures you control get +2/+0 until end of turn.
        this.getSpellAbility().addEffect(new BoostControlledEffect(2, 0, Duration.EndOfTurn));
    }

    private DarkTriumph(final DarkTriumph card) {
        super(card);
    }

    @Override
    public DarkTriumph copy() {
        return new DarkTriumph(this);
    }
}
