
package mage.cards.d;

import java.util.UUID;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.target.common.TargetControlledPermanent;

/**
 *
 * @author Loki
 */
public final class DarkHeartOfTheWood extends CardImpl {

    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Forest");

    static {
        filter.add(SubType.FOREST.getPredicate());
    }

    public DarkHeartOfTheWood(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{B}{G}");


        // Sacrifice a Forest: You gain 3 life.
        this.addAbility(new SimpleActivatedAbility(new GainLifeEffect(3), new SacrificeTargetCost(filter)));
    }

    private DarkHeartOfTheWood(final DarkHeartOfTheWood card) {
        super(card);
    }

    @Override
    public DarkHeartOfTheWood copy() {
        return new DarkHeartOfTheWood(this);
    }
}
