
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.common.FilterCreaturePermanent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author jeffwadsworth
 */
public final class CrumblingAshes extends CardImpl {
    
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with a -1/-1 counter on it");
    
    static {
        filter.add(CounterType.M1M1.getPredicate());
    }

    public CrumblingAshes(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{1}{B}");


        // At the beginning of your upkeep, destroy target creature with a -1/-1 counter on it.
        Ability ability = new BeginningOfUpkeepTriggeredAbility(new DestroyTargetEffect());
        Target target = new TargetCreaturePermanent(filter);
        ability.addTarget(target);
        this.addAbility(ability);
        
    }

    private CrumblingAshes(final CrumblingAshes card) {
        super(card);
    }

    @Override
    public CrumblingAshes copy() {
        return new CrumblingAshes(this);
    }
}
