
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.PreventDamageToControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.TargetPlayer;

/**
 *
 * @author KholdFuzion
 *
 */
public final class Conservator extends CardImpl {

    public Conservator(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{4}");

        // {3}, {T}: Prevent the next 2 damage that would be dealt to you this turn.
        Ability ability = new SimpleActivatedAbility(new PreventDamageToControllerEffect(Duration.EndOfTurn, 2), new GenericManaCost(3));
        ability.addCost(new TapSourceCost());
        this.addAbility(ability);
    }

    private Conservator(final Conservator card) {
        super(card);
    }

    @Override
    public Conservator copy() {
        return new Conservator(this);
    }
}
