package mage.cards.c;

import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.ConvokeAbility;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.*;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.permanent.AnotherEnchantedPredicate;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

import java.util.UUID;

/**
 * @author Galatolol
 */
public final class ConclavesBlessing extends CardImpl {

    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("other creature you control");

    static {
        filter.add(AnotherEnchantedPredicate.instance);
    }

    public ConclavesBlessing(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{W}");
        this.subtype.add(SubType.AURA);

        // Convoke
        this.addAbility(new ConvokeAbility());

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.BoostCreature));
        this.addAbility(new EnchantAbility(auraTarget));

        // Enchanted creature gets +0/+2 for each other creature you control.
        PermanentsOnBattlefieldCount value = new PermanentsOnBattlefieldCount(filter, 2);
        BoostEnchantedEffect effect = new BoostEnchantedEffect(StaticValue.get(0), value, Duration.WhileOnBattlefield);
        effect.setText("Enchanted creature gets +0/+2 for each other creature you control.");
        this.addAbility(new SimpleStaticAbility(effect));
    }

    private ConclavesBlessing(final ConclavesBlessing card) {
        super(card);
    }

    @Override
    public ConclavesBlessing copy() {
        return new ConclavesBlessing(this);
    }
}
