package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.IntPlusDynamicValue;
import mage.abilities.dynamicvalue.common.MultikickerCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.MultikickerAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetAnyTarget;
import mage.target.targetadjustment.TargetsCountAdjuster;
import mage.util.CardUtil;

import java.util.UUID;

/**
 * @author jeffwadsworth
 */
public final class CometStorm extends CardImpl {

    public CometStorm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{X}{R}{R}");

        // Multikicker {1}
        this.addAbility(new MultikickerAbility("{1}"));

        // Choose any target, then choose another any target for each time Comet Storm was kicked. Comet Storm deals X damage to each of them.
        this.getSpellAbility().addEffect(new CometStormEffect());
        this.getSpellAbility().addTarget(new TargetAnyTarget(1));
        this.getSpellAbility().addTarget(new TargetAnyTarget());
        this.getSpellAbility().setTargetAdjuster(new TargetsCountAdjuster(new IntPlusDynamicValue(1, MultikickerCount.instance)));
    }

    private CometStorm(final CometStorm card) {
        super(card);
    }

    @Override
    public CometStorm copy() {
        return new CometStorm(this);
    }
}

class CometStormEffect extends OneShotEffect {

    CometStormEffect() {
        super(Outcome.Damage);
        staticText = "Choose any target, then choose another target for each time this spell was kicked. {this} deals X damage to each of them";
    }

    private CometStormEffect(final CometStormEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int damage = CardUtil.getSourceCostsTag(game, source, "X", 0);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID uuid : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(uuid);
                Player player = game.getPlayer(uuid);
                if (permanent != null) {
                    permanent.damage(damage, source.getSourceId(), source, game, false, true);
                }
                if (player != null) {
                    player.damage(damage, source.getSourceId(), source, game);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public CometStormEffect copy() {
        return new CometStormEffect(this);
    }
}
