
package mage.cards.c;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.EnchantedCreatureColorCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.ShroudAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author Plopman
 */
public final class CloutOfTheDominus extends CardImpl {

    public CloutOfTheDominus(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{U/R}");
        this.subtype.add(SubType.AURA);


        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.AddAbility));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);
        // As long as enchanted creature is blue, it gets +1/+1 and has shroud.
        SimpleStaticAbility blueAbility = new SimpleStaticAbility(new ConditionalContinuousEffect(
                new BoostEnchantedEffect(1, 1), new EnchantedCreatureColorCondition(ObjectColor.BLUE), "As long as enchanted creature is blue, it gets +1/+1"));
        blueAbility.addEffect(new ConditionalContinuousEffect(new GainAbilityAttachedEffect(ShroudAbility.getInstance(), AttachmentType.AURA), 
                new EnchantedCreatureColorCondition(ObjectColor.BLUE), "and has shroud"));
        this.addAbility(blueAbility);
        
        // As long as enchanted creature is red, it gets +1/+1 and has haste.
        SimpleStaticAbility redAbility = new SimpleStaticAbility(new ConditionalContinuousEffect(
                new BoostEnchantedEffect(1, 1), new EnchantedCreatureColorCondition(ObjectColor.RED), "As long as enchanted creature is red, it gets +1/+1"));
        redAbility.addEffect(new ConditionalContinuousEffect(new GainAbilityAttachedEffect(HasteAbility.getInstance(), AttachmentType.AURA), 
                new EnchantedCreatureColorCondition(ObjectColor.RED), "and has haste"));
        this.addAbility(redAbility);
    }

    private CloutOfTheDominus(final CloutOfTheDominus card) {
        super(card);
    }

    @Override
    public CloutOfTheDominus copy() {
        return new CloutOfTheDominus(this);
    }
}
