
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.MountainwalkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author fireshoes
 */
public final class CavePeople extends CardImpl {

    public CavePeople(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{R}{R}");
        this.subtype.add(SubType.HUMAN);
        this.power = new MageInt(1);
        this.toughness = new MageInt(4);

        // Whenever Cave People attacks, it gets +1/-2 until end of turn.
        this.addAbility(new AttacksTriggeredAbility(new BoostSourceEffect(1, -2, Duration.EndOfTurn), false));
        
        // {1}{R}{R}, {tap}: Target creature gains mountainwalk until end of turn.
        Ability ability = new SimpleActivatedAbility(new GainAbilityTargetEffect(new MountainwalkAbility(), Duration.EndOfTurn), new ManaCostsImpl<>("{1}{R}{R}"));
        ability.addCost(new TapSourceCost());
        ability.addTarget(new TargetCreaturePermanent());
        this.addAbility(ability);
    }

    private CavePeople(final CavePeople card) {
        super(card);
    }

    @Override
    public CavePeople copy() {
        return new CavePeople(this);
    }
}
