
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.SourceTappedCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class CastleRaptors extends CardImpl {

    public CastleRaptors(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{4}{W}");
        this.subtype.add(SubType.BIRD);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // As long as Castle Raptors is untapped, it gets +0/+2.
        this.addAbility(new SimpleStaticAbility(new ConditionalContinuousEffect(
            new BoostSourceEffect(0, 2, Duration.WhileOnBattlefield), SourceTappedCondition.UNTAPPED,
            "As long as {this} is untapped, it gets +0/+2.")));
    }

    private CastleRaptors(final CastleRaptors card) {
        super(card);
    }

    @Override
    public CastleRaptors copy() {
        return new CastleRaptors(this);
    }
}
