
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author Loki
 */
public final class CarrionHowler extends CardImpl {

    public CarrionHowler(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{B}");
        this.subtype.add(SubType.ZOMBIE);
        this.subtype.add(SubType.WOLF);

        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // Pay 1 life: Carrion Howler gets +2/-1 until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(2, -1, Duration.EndOfTurn), new PayLifeCost(1)));
    }

    private CarrionHowler(final CarrionHowler card) {
        super(card);
    }

    @Override
    public CarrionHowler copy() {
        return new CarrionHowler(this);
    }
}
