
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Zone;

/**
 *
 * @author Backfir3
 */
public final class BraidwoodCup extends CardImpl {

    public BraidwoodCup(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{3}");

        // {T}: You gain 1 life.
        Ability ability = new SimpleActivatedAbility(new GainLifeEffect(1), new TapSourceCost());
        this.addAbility(ability);
    }

    private BraidwoodCup(final BraidwoodCup card) {
        super(card);
    }

    @Override
    public BraidwoodCup copy() {
        return new BraidwoodCup(this);
    }
}
