
package mage.cards.b;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author Loki
 */
public final class BottleGnomes extends CardImpl {

    public BottleGnomes(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT,CardType.CREATURE},"{3}");
        this.subtype.add(SubType.GNOME);
        this.power = new MageInt(1);
        this.toughness = new MageInt(3);
        this.addAbility(new SimpleActivatedAbility(new GainLifeEffect(3), new SacrificeSourceCost()));
    }

    private BottleGnomes(final BottleGnomes card) {
        super(card);
    }

    @Override
    public BottleGnomes copy() {
        return new BottleGnomes(this);
    }
}
