

package mage.cards.b;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author Loki
 */
public final class BoneSaw extends CardImpl {

    public BoneSaw(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{0}");
        this.subtype.add(SubType.EQUIPMENT);
        this.addAbility(new SimpleStaticAbility(new BoostEquippedEffect(1, 0)));
        this.addAbility(new EquipAbility(Outcome.AddAbility, new GenericManaCost(1)));
}

    private BoneSaw(final BoneSaw card) {
        super(card);
    }

    @Override
    public BoneSaw copy() {
        return new BoneSaw(this);
    }

}
