
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author fireshoes
 */
public final class BoneFlute extends CardImpl {

    public BoneFlute(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{3}");

        // {2}, {tap}: All creatures get -1/-0 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostAllEffect(-1, -0, Duration.EndOfTurn), new GenericManaCost(2));
        ability.addCost(new TapSourceCost());
        this.addAbility(ability);
    }

    private BoneFlute(final BoneFlute card) {
        super(card);
    }

    @Override
    public BoneFlute copy() {
        return new BoneFlute(this);
    }
}
