
package mage.cards.b;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author TheElk801
 */
public final class BoaConstrictor extends CardImpl {

    public BoaConstrictor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{4}{G}");

        this.subtype.add(SubType.SNAKE);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);

        // {tap}: Boa Constrictor gets +3/+3 until end of turn.
        this.addAbility(new SimpleActivatedAbility(new BoostSourceEffect(3, 3, Duration.EndOfTurn), new TapSourceCost()));
    }

    private BoaConstrictor(final BoaConstrictor card) {
        super(card);
    }

    @Override
    public BoaConstrictor copy() {
        return new BoaConstrictor(this);
    }
}
