
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 *
 * @author LevelX2
 */
public final class BloodMist extends CardImpl {

    public BloodMist(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{3}{R}");

        // At the beginning of combat on your turn, target creature you control gains double strike until end of turn.
        Ability ability = new BeginningOfCombatTriggeredAbility(new GainAbilityTargetEffect(DoubleStrikeAbility.getInstance(), Duration.EndOfTurn));
        ability.addTarget(new TargetControlledCreaturePermanent());
        this.addAbility(ability);

    }

    private BloodMist(final BloodMist card) {
        super(card);
    }

    @Override
    public BloodMist copy() {
        return new BloodMist(this);
    }
}
