
package mage.cards.b;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;

/**
 *
 * @author LevelX2
 */
public final class BattleBrawler extends CardImpl {

    private static final FilterControlledPermanent filter = new FilterControlledPermanent("As long as you control a red or white permanent");

    static {
        filter.add(Predicates.or(new ColorPredicate(ObjectColor.RED), new ColorPredicate(ObjectColor.WHITE)));
    }

    public BattleBrawler(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{B}");
        this.subtype.add(SubType.ORC);
        this.subtype.add(SubType.WARRIOR);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);

        // As long as you control a red or white permanent, Battle Brawler gets +1/+0 and has first strike.
        Ability ability = new SimpleStaticAbility(
                new ConditionalContinuousEffect(new BoostSourceEffect(1,0, Duration.WhileOnBattlefield),
                new PermanentsOnTheBattlefieldCondition(filter), "As long as you control a red or white permanent, {this} gets +1/+0"));
        ability.addEffect(new ConditionalContinuousEffect(new GainAbilitySourceEffect(FirstStrikeAbility.getInstance(), Duration.WhileOnBattlefield),
                new PermanentsOnTheBattlefieldCondition(filter), "and has first strike"));
        this.addAbility(ability);
    }

    private BattleBrawler(final BattleBrawler card) {
        super(card);
    }

    @Override
    public BattleBrawler copy() {
        return new BattleBrawler(this);
    }
}
