

package mage.cards.b;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.target.common.TargetControlledCreaturePermanent;

/**
 *
 * @author Loki
 */
public final class BarbedBattlegear extends CardImpl {

    public BarbedBattlegear (UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ARTIFACT},"{3}");
        this.subtype.add(SubType.EQUIPMENT);

        // Equipped creature gets +4/-1.
        this.addAbility(new SimpleStaticAbility(new BoostEquippedEffect(4, -1)));

        // Equip {2}
        this.addAbility(new EquipAbility(Outcome.Neutral, new GenericManaCost(2), new TargetControlledCreaturePermanent(), false));
    }

    private BarbedBattlegear(final BarbedBattlegear card) {
        super(card);
    }

    @Override
    public BarbedBattlegear copy() {
        return new BarbedBattlegear(this);
    }

}
